/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class TravelersBackpackCurios {
    public static ICurio createBackpackProvider() {
        return new TravelersBackpackCurio(ItemStack.f_41583_);
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioTravelersBackpack(LivingEntity livingEntity) {
        Predicate<ItemStack> backpack = stack -> stack.m_41720_() instanceof TravelersBackpackItem;
        return CuriosApi.getCuriosHelper().findEquippedCurio(backpack, livingEntity);
    }

    public static ItemStack getCurioTravelersBackpackStack(Player player) {
        if (TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).isPresent()) {
            return (ItemStack)TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).get().getRight();
        }
        return ItemStack.f_41583_;
    }

    public static TravelersBackpackContainer getCurioTravelersBackpackInventory(Player player) {
        TravelersBackpackContainer curioContainer = CapabilityUtils.getCapability(player).map(ITravelersBackpack::getContainer).orElse(null);
        if (curioContainer.getItemStack() != TravelersBackpackCurios.getCurioTravelersBackpackStack(player)) {
            curioContainer.setStack(TravelersBackpackCurios.getCurioTravelersBackpackStack(player));
            curioContainer.loadAllData(TravelersBackpackCurios.getCurioTravelersBackpackStack(player).m_41784_());
        }
        return curioContainer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderCurioLayer(AbstractClientPlayer clientPlayer) {
        if (TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)clientPlayer).isPresent()) {
            return CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)clientPlayer, stack -> stack.m_41720_() instanceof TravelersBackpackItem).map(result -> result.slotContext().visible()).orElse(false);
        }
        return false;
    }

    public static void rightClickUnequip(Player player, ItemStack stack) {
        if (TravelersBackpack.enableCurios() && CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, p -> ItemStack.m_150942_((ItemStack)p, (ItemStack)stack)).isPresent()) {
            int backpackSlot = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, p -> ItemStack.m_150942_((ItemStack)p, (ItemStack)stack)).get()).slotContext().index();
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(iCuriosItemHandler -> iCuriosItemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier())).ifPresent(iCurioStacksHandler -> ((ICurioStacksHandler)iCurioStacksHandler.get()).getStacks().setStackInSlot(backpackSlot, ItemStack.f_41583_));
        }
    }

    public static boolean rightClickEquip(Player player, ItemStack stack, boolean simulate) {
        if (CuriosApi.getCuriosHelper().getCurio(stack).isPresent() && CuriosApi.getCuriosHelper().getCurio(stack).resolve().isPresent()) {
            ICurio curio = (ICurio)CuriosApi.getCuriosHelper().getCurio(stack).resolve().get();
            LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
            if (curiosHandler.isPresent() && curiosHandler.resolve().isPresent()) {
                int index = -1;
                boolean isEmptySlot = false;
                ICurioStacksHandler curioHandler = (ICurioStacksHandler)((ICuriosItemHandler)curiosHandler.resolve().get()).getCurios().get("back");
                for (int i = 0; i < curioHandler.getSlots(); ++i) {
                    if (!curioHandler.getStacks().getStackInSlot(i).m_41619_()) continue;
                    index = i;
                    isEmptySlot = true;
                }
                if (!isEmptySlot) {
                    return false;
                }
                NonNullList renderStates = curioHandler.getRenders();
                SlotContext slotContext = new SlotContext(curioHandler.getIdentifier(), (LivingEntity)player, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false);
                if (curio.canEquip(slotContext)) {
                    if (simulate) {
                        return true;
                    }
                    curioHandler.getStacks().setStackInSlot(index, stack.m_41777_());
                    curio.onEquipFromUse(slotContext);
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.f_19853_.f_46441_.m_188501_() - player.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    CapabilityUtils.synchronise(player);
                    CapabilityUtils.synchroniseToOthers(player);
                    return true;
                }
            }
        }
        return false;
    }
}

